
set sql_safe_updates=0;
-- APPLICANT_APPOINTMENT_RECIPIENT        
SET @applicantAppointmentRecipent=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    sg.id AS ID,
    T1.code AS APPLICANT_CODE,
    T2.firstName AS FIRST_NAME,
    T2.lastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl)
	else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
		LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id
WHERE
    sg.id IN (namedParams) and sg.isAppointeeAppointment = TRUE" WHERE `dataProviderId`=@applicantAppointmentRecipent; 
    
 -- APPOINTMENT_RECIPIENT        
SET @appointmentRecipent=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,    
    T1.`appointeeName` AS PRINT_NAME,
    T1.`appointeeEmailId` AS EMAIL_ID,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(substring_index(personToMeet, '/', -1)) as PERSON_TO_MEET, 
    TRIM(substring_index(appointeeContactNo, '-', 1)) as MOBILE_CODE, 
    TRIM(substring_index(appointeeContactNo, '-', -1)) as MOBILE_NO,
    TRIM(substring_index(appointeeName, '/', -1)) as FIRST_NAME
FROM
    `sg_appointment` T1 	
WHERE
    T1.id IN (namedParams) and T1.isAppointeeAppointment = TRUE" WHERE `dataProviderId`=@appointmentRecipent;   
    
  -- PERSON_TO_MEET_APPOINTMENT
   
SET @personToMeetApp=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME,
    ml.code as LANGUAGE_KEY
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    staffs entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
    LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams) and T1.isAppointeeAppointment = TRUE 
UNION SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
	TRIM(substring_index(appointeeName, '/', -1)) AS APPOINTEE_NAME,
    ml.code as LANGUAGE_KEY
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    students entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
    LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams) and T1.isAppointeeAppointment = TRUE" WHERE `dataProviderId`=@personToMeetApp; 
    
  -- ENQUIRY_APPOINTMENT_RECIPIENT
   
SET @enquiryAppointmentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_APPOINTMENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    sg.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRSTNAME,
    T1.lastName AS PARENT_LASTNAME,
    T2.studentFirstName AS FIRST_NAME,
    T2.studentLastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    enquiry T1 ON T1.id = sg.enquiryId
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    sg.id IN (namedParams) and sg.isAppointeeAppointment = TRUE" WHERE `dataProviderId`=@enquiryAppointmentId;    
    
    set sql_safe_updates=1;